# delimit ; 
clear all; 
set mem 300m;	
set more 1 ;  
drop _all;
program drop _all;
capture log close;

*cd C:\Dropbox\hrs\wealthcouples;
* cd C:\Users\Eric\Dropbox\hrs\wealthcouples;
cd C:\Users\ebf26\Dropbox\hrs\wealthcouples;

log using incprof.log, replace; 
use dataprep2_4states;

gen useheal=0 ;
********************************************;
* IMPORTANT NOTE ABOUT THE DATA             ;
* WAVE 1 OF THE AHEAD IS PRETTY SCREWED UP  ;
* THE QUESTIONS ASKED ARE LESS COMPREHENSIVE;
* THAN IN OTHER WAVES, AND SO THE MEANS OF  ;
* DIFFERENT VARIABLES ARE LOWER             ;
********************************************;
*drop if (wave==2);
*drop if (wave==3);

replace lhhinc=. if (wave==2|wave==3);
replace lanninc=. if (wave==2|wave==3);
replace lsocy=. if (wave==2|wave==3);
*replace linc=. if (wave==2|wave==3);


keep ageshiftvarc sing*all bPI* hhage;

sort hhage;
drop if hhage==hhage[_n-1];


gen low=.2;
gen low2=low^2;
gen low3=low^3;
gen low4=low^4;
gen low5=low^5;

gen high=.8;
gen high2=high^2;
gen high3=high^3;
gen high4=high^4;
gen high5=high^5;

gen b_low=bPI0+bPI1*low+bPI2*low2+bPI3*low3+bPI4*low4+bPI5*low5;
gen b_high=bPI0+bPI1*high+bPI2*high2+bPI3*high3+bPI4*high4+bPI5*high5;

*this program generates average income at different percentiles of the income distribution;
program define genPIshift;
        version 3.1;

		gen low_couple=b_low+ageshiftvarc;
		gen low_male=b_low+ageshiftvarc+singmshift_all;
		gen low_female=b_low+ageshiftvarc+singfshift_all;
		
		
		gen high_couple=b_high+ageshiftvarc;
		gen high_male=b_high+ageshiftvarc+singmshift_all;
		gen high_female=b_high+ageshiftvarc+singfshift_all;
		
	
	gen _20th_percentile_couple=exp(low_couple);
	gen _20th_percentile_male=exp(low_male);
	gen _20th_percentile_female=exp(low_female);

	gen _80th_percentile_couple=exp(high_couple);
	gen _80th_percentile_male=exp(high_male);
	gen _80th_percentile_female=exp(high_female);

end;


drop if hhage>102|hhage<70;
sort hhage;
rename hhage age;

save incprof, replace;

***********************************;
* GRAPHS                           ;
***********************************;

set scheme s1mono;

* GRAPHS;

****************** couples;
genPIshift;

twoway connected _20th_percentile_couple _80th_percentile_couple age, ysc(r(7000 20000)) ylabel(10000 20000 30000) msymbol(T S D O) lpattern(solid longdash shortdash longdash_dot) ti("Income, by Permanent Income Percentile, Couples",size(medlarge)) l1(2014 dollars) ytitle("") saving(income, replace);
graph use income.gph;
graph display, ysize(6) xsize(8.25);
graph export graphs\income_couples.eps, replace;
graph export graphs\income_couples.emf, replace;
**********numbers behind the graphs****************;
sort age;
by age: sum _20th_percentile_couple _80th_percentile_couple age;



*************** single women;
twoway connected _20th_percentile_female _80th_percentile_female age, ysc(r(7000 20000)) ylabel(10000 20000 30000) msymbol(T S D O) lpattern(solid longdash shortdash longdash_dot) ti("Income, by Permanent Income Percentile, Single Females",size(medlarge)) l1(2014 dollars) ytitle("") saving(income, replace);
graph use income.gph;
graph display, ysize(6) xsize(8.25);
graph export graphs\income_females.eps, replace;
graph export graphs\income_females.emf, replace;
**********numbers behind the graphs****************;
sort age;
by age: sum _20th_percentile_female _80th_percentile_female age;

******************** single men;
twoway connected _20th_percentile_male _80th_percentile_male age, ysc(r(7000 20000)) ylabel(10000 20000 30000) msymbol(T S D O) lpattern(solid longdash shortdash longdash_dot) ti("Income, by Permanent Income Percentile, Single Females",size(medlarge)) l1(2014 dollars) ytitle("") saving(income, replace);
graph use income.gph;
graph display, ysize(6) xsize(8.25);
graph export graphs\income_males.eps, replace;
graph export graphs\income_males.emf, replace;
**********numbers behind the graphs****************;
sort age;
by age: sum _20th_percentile_male _80th_percentile_male age;




* income given loss of a spouse;
gen _20th_percentile_to_male=_20th_percentile_couple;
replace _20th_percentile_to_male=_20th_percentile_male if age>79;

gen _20th_percentile_to_female=_20th_percentile_couple;
replace _20th_percentile_to_female=_20th_percentile_female if age>79;

gen _80th_percentile_to_male=_80th_percentile_couple;
replace _80th_percentile_to_male=_80th_percentile_male if age>79;

gen _80th_percentile_to_female=_80th_percentile_couple;
replace _80th_percentile_to_female=_80th_percentile_female if age>79;

la var _20th_percentile_to_female "20th percentile to female";
la var _80th_percentile_to_female "80th percentile to female";
la var _20th_percentile_to_male "20th percentile to male";
la var _80th_percentile_to_male "80th percentile to male"; 
la var _20th_percentile_couple "20th percentile couple";
la var _80th_percentile_couple "80th percentile couple";
 
******************** the key graph;
twoway connected 
_20th_percentile_to_female _80th_percentile_to_female _20th_percentile_to_male _80th_percentile_to_male 
_20th_percentile_couple _80th_percentile_couple age, 
ysc(r(7000 35000)) ylabel(0 10000 20000 30000) msymbol(O S Oh Sh O S) 
lcolor(pink*.5 pink*.5 blue blue green*1.8 green*1.8 ) 
mcolor(pink*.5 pink*.5 blue blue green*1.8 green*1.8)
/*mcolor(gs8 gs8 gs0 gs0 gs0 gs0) */
lpattern(solid solid solid solid solid solid) 
ti("Income, by Permanent Income Percentile, Initially Couples",size(medlarge)) l1(2014 dollars) ytitle("") saving(income, replace) legend(order(5 6 1 2 3 4))
yline(5000 10000 15000 20000 25000 30000 35000, lstyle(grid));
graph use income.gph;
graph display, ysize(6) xsize(8.25);
graph export graphs\income_initial_couples.eps, replace;
graph export graphs\income_initial_couples.emf, replace;


use incprof, replace;

keep age ageshiftvarc  singmshift_all singfshift_all bPI0-bPI5;
order age ageshiftvarc  singmshift_all singfshift_all bPI0-bPI5;

sum;


outsheet using incprof,nonames replace;
drop _all;
program drop _all;
log close;


